/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */
#ifndef _ev_common_h_
#define _ev_common_h_

#include <dtvrecdd/ev_id.h>

#define EV_MAX_MESSAGE_LENGTH 2048

#define EV_MAX_IDS_IN_THREAD		24

#define EV_MAX_THREADS_IN_PROCESS	8

#define EV_MAX_IDS_IN_PROCESS					\
		(EV_MAX_IDS_IN_THREAD * EV_MAX_THREADS_IN_PROCESS)

enum ev_err
{
	EV_OK = 0,
	EV_ERR_Exist,
	EV_ERR_Invalid_ID,
	EV_ERR_Busy,
	EV_ERR_Interrupted,
	EV_ERR_Thread_Over,
	EV_ERR_Invalid_Thread,
	EV_ERR_Fatal,
};

typedef INT32 EV_ERR;

typedef UINT32 EV_Type;

enum ev_type
{
	EV_EVENT_None = 0x00000000,

	EV_EVENT_Flag = 0x0001,
#define EV_EVENT_IS_FLAG(tp) (((tp) & EV_EVENT_Flag) != 0)

	EV_EVENT_Message = 0x0002,
#define EV_EVENT_IS_MESSAGE(tp) (((tp) & EV_EVENT_Message) != 0)

	EV_EVENT_Flag64 = 0x0003,
#define EV_EVENT_IS_FLAG64(tp) (((tp) & EV_EVENT_Flag64) != 0)

};

typedef struct
{
	EV_ID   flagID;
	UINT32  bits;
} EV_Flag;

typedef struct
{
	EV_ID   flagID;
	UINT64  bits;
} EV_Flag64;

typedef struct
{
	EV_ID   queueID;
	UINT32  senderInfo;
	UINT32  length;
	UINT8   message[EV_MAX_MESSAGE_LENGTH];
} EV_Message;

typedef struct
{
	EV_Type type;
	union
	{
		EV_Flag flag;
		EV_Flag64 flag64;
		EV_Message message;
	} u;
} EV_Event;

enum ev_message_queue_type
{
	EV_MESSAGE_QUEUE_TYPE_BUSY,
	EV_MESSAGE_QUEUE_TYPE_FIFO,
	EV_MESSAGE_QUEUE_TYPE_REPLACE,
};

typedef UINT8 EV_Message_Queue_Type;

#endif
